# 04.. AGGIUNGERE UN MENU SU DATABASE

Quando si sviluppa una nuova funzionalità di un modulo e la si vuole collegare ad un menu del gestionale occorre aggiungere una riga dello script interessato per esempio come segue.
Gli aggiornamenti al database vengono prese dal file __setup/install/update_to_7.23.sql__ (se supponiamo di aggiornare il database alla *versione 7.23*).

*Esempio*
```sql
UPDATE `gaz_config` SET `cvalue` = '119' WHERE `id` =2;
INSERT INTO `gaz_menu_script` SELECT MAX(id)+1, (SELECT id FROM `gaz_menu_module` WHERE `link`='select_regiva.php'), 'select_regcor.php', '', '', 13, '', 16  FROM `gaz_menu_script`;

-- START_WHILE ( questo e' un tag che serve per istruire install.php ad INIZIARE ad eseguire le query seguenti su tutte le aziende dell'installazione)
INSERT INTO `gaz_XXXcompany_config` (`description`, `var`, `val`) VALUES ('Controlla regolarità indirizzo in inserimento cliente (0=No, 1=Si)', 'check_cust_address', '1');
-- STOP_WHILE ( questo e' un tag che serve per istruire install.php a SMETTERE di eseguire le query su tutte le aziende dell'installazione)
```

Da notare come sia strutturato questo file:
- La prima parte fino alla riga *START_WHILE* viene eseguita solo una volta
- La seconda parte da *START_WHILE* a *STOP_WHILE* viene eseguita tante volte per quante sono le aziende installate

## PRIMA PARTE UPDATE SQL

Il primo sql UPDATE riguarda la versione del database che si sta installando (ossia 119)
La seconda sql INSERT riguarda l'aggiunta di uno script menu che si va ad inserire sotto il link *select_regiva.php* e prende il nome dal file *menu.italian.php* dall'array:

```php
$transl['contab'] = array('name' => "Contabilità",
    'title' => "Gestione Prima Nota e I.V.A.",
    'm2' => array(1 => array("Prima nota, inserimento, modifica, eliminazione dei movimenti contabili ed I.V.A.", "Prima Nota"),
        2 => array("Gestione del Piano dei Conti", "Piano dei conti"),
        3 => array("Gestione dell'Archivio delle Causali Contabili", "Causali Contabili"),
        4 => array("Visualizzazione e stampa dei registri I.V.A.", "Registri IVA"),
        5 => array("Preparazione file per Comunicazioni dati", "Comunicazioni dati"),
        6 => array("Visualizzazione e stampa del Libro Giornale", "Libro Giornale"),
        7 => array("Visualizzazione e stampa della situazione contabile", "Situazione contabile"),
    ),
    'm3' => array(1 => array("Inserisci un nuovo movimento contabile", "Nuovo movimento contabile"),
        2 => array("Inserisci un nuovo conto", "Nuovo conto"),
        3 => array("Visualizzazione e stampa dei partitari", "Visualizza/stampa partitari"),
        4 => array("Inserisci un nuova causale contabile", "Nuova causale contabile"),
        5 => array("Stampa il piano dei conti", "Stampa Piano dei Conti"),
        6 => array("Visualizzazione e stampa di estratti conto o partite aperte", "Estratti Conto/Partite Aperte"),
        7 => array("Visualizzazione e stampa di dare/avere clienti/fornitori", "Analisi Debiti/Crediti"),
        8 => array("Comunicazione liquidazioni IVA", "Comunicazione liquidazioni IVA"),
        9 => array("File XML per Comunicazioni liquidazioni IVA", "Lista File Comunicazioni liquidazioni IVA"),
        10 => array("File XML per Comunicazione dati fatture", "Comunicazione dati fatture"),
        11 => array("Visualizzazione e stampa del registro riepilogativo I.V.A.", "Liquidazione IVA"),
        12 => array("File XML per Comunicazioni dati fatture", "Lista File Comunicazioni dati fatture"),
        13 => array( "Visualizza registro corrispettivi giornalieri", "Registro Corrispettivi"),
    )
);
```
Il menu risultante sarà **Contabilità->Registri IVA->Registro Corrispettivi**.

## SECONDA PARTE UPDATE SQL

Dall'esempio di cui sopra si aggiunge per ogni azienda un nuovo valore di configurazione aziendale.
